/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared;

import dan200.computercraft.core.apis.http.NetworkUtils;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ResourceMount;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.computer.metrics.ComputerMBean;
import dan200.computercraft.shared.lectern.CustomLecternBlock;
import dan200.computercraft.shared.peripheral.monitor.MonitorWatcher;
import dan200.computercraft.shared.util.DropConsumer;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.TickScheduler;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2818;
import net.minecraft.class_2960;
import net.minecraft.class_3176;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3302;
import net.minecraft.class_3715;
import net.minecraft.class_39;
import net.minecraft.class_3965;
import net.minecraft.class_44;
import net.minecraft.class_52;
import net.minecraft.class_5321;
import net.minecraft.class_55;
import net.minecraft.class_5658;
import net.minecraft.class_7225;
import net.minecraft.class_7699;
import net.minecraft.class_7706;
import net.minecraft.class_79;
import net.minecraft.class_7924;
import net.minecraft.class_83;
import net.minecraft.class_9299;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.server.MinecraftServer;
import org.jspecify.annotations.Nullable;

public final class CommonHooks {
    private static @Nullable MinecraftServer server;
    public static final class_5321<class_52> TREASURE_DISK_LOOT;
    private static final Set<class_5321<class_52>> TREASURE_DISK_LOOT_TABLES;

    private CommonHooks() {
    }

    @Deprecated
    public static @Nullable MinecraftServer getServer() {
        return server;
    }

    public static void onServerTickStart(MinecraftServer server) {
        ServerContext.get(server).tick();
        TickScheduler.tick();
    }

    public static void onServerTickEnd() {
        MonitorWatcher.onTick();
    }

    public static void onServerStarting(MinecraftServer server) {
        if (server instanceof class_3176) {
            class_3176 dediServer = (class_3176)server;
            if (dediServer.method_16705().field_24056) {
                ComputerMBean.register();
            }
        }
        CommonHooks.resetState();
        ServerContext.create(server);
        ComputerMBean.start(server);
    }

    public static void onServerStarted(MinecraftServer server) {
        CommonHooks.server = server;
        class_7706.method_47330((class_7699)server.method_27728().method_45560(), (boolean)false, (class_7225.class_7874)server.method_30611());
    }

    public static void onServerStopped() {
        CommonHooks.resetState();
    }

    private static void resetState() {
        server = null;
        ServerContext.close();
        NetworkUtils.reset();
    }

    public static void onServerChunkUnload(class_2818 chunk) {
        if (!(chunk.method_12200() instanceof class_3218)) {
            throw new IllegalArgumentException("Not a server chunk.");
        }
        TickScheduler.onChunkUnload(chunk);
    }

    public static void onChunkWatch(class_2818 chunk, class_3222 player) {
        MonitorWatcher.onWatch(chunk, player);
    }

    public static void onChunkTicketLevelChanged(class_3218 level, long chunkPos, int oldLevel, int newLevel) {
        TickScheduler.onChunkTicketChanged(level, chunkPos, oldLevel, newLevel);
    }

    public static class_1269 onUseBlock(class_1657 player, class_1937 level, class_1268 hand, class_3965 hitResult) {
        if (player.method_7325()) {
            return class_1269.field_5811;
        }
        class_2338 pos = hitResult.method_17777();
        class_1799 heldItem = player.method_5998(hand);
        class_2680 blockState = level.method_8320(pos);
        if (blockState.method_27852(class_2246.field_16330) && !((Boolean)blockState.method_11654((class_2769)class_3715.field_17366)).booleanValue()) {
            return CustomLecternBlock.tryPlaceItem(player, level, pos, blockState, heldItem);
        }
        return class_1269.field_5811;
    }

    public static // Could not load outer class - annotation placement on inner may be incorrect
    @Nullable class_55.class_56 getExtraLootPool(class_5321<class_52> lootTable) {
        if (!TREASURE_DISK_LOOT_TABLES.contains(lootTable)) {
            return null;
        }
        return class_55.method_347().method_351((class_79.class_80)class_83.method_428(TREASURE_DISK_LOOT)).method_352((class_5658)class_44.method_32448((float)1.0f));
    }

    public static void onDatapackReload(BiConsumer<String, class_3302> addReload) {
        addReload.accept("mounts", (class_3302)ResourceMount.RELOAD_LISTENER);
    }

    public static boolean onEntitySpawn(class_1297 entity) {
        return DropConsumer.onEntitySpawn(entity);
    }

    public static boolean onLivingDrop(class_1297 entity, class_1799 stack) {
        return DropConsumer.onLivingDrop(entity, stack);
    }

    public static void onBuildCreativeTab(class_5321<class_1761> key, class_1761.class_8128 context, class_1761.class_7704 out) {
        if (key == class_7706.field_41063 && context.comp_1252()) {
            out.method_45421((class_1935)ModRegistry.Items.COMPUTER_COMMAND.get());
        }
    }

    public static void onItemTooltip(class_1799 stack, class_1792.class_9635 context, class_1836 flags, List<class_2561> out) {
        NonNegativeId computerId;
        TooltipAppender appender = new TooltipAppender(out);
        CommonHooks.addToTooltip(stack, (class_9331)ModRegistry.DataComponents.PRINTOUT.get(), context, appender, flags);
        CommonHooks.addToTooltip(stack, (class_9331)ModRegistry.DataComponents.TREASURE_DISK.get(), context, appender, flags);
        NonNegativeId diskId = (NonNegativeId)stack.method_57824((class_9331)ModRegistry.DataComponents.DISK_ID.get());
        if (diskId != null && flags.method_8035()) {
            diskId.addToTooltip("gui.computercraft.tooltip.disk_id", appender);
        }
        if ((computerId = (NonNegativeId)stack.method_57824((class_9331)ModRegistry.DataComponents.COMPUTER_ID.get())) != null && (flags.method_8035() || !stack.method_57826(class_9334.field_49631))) {
            computerId.addToTooltip("gui.computercraft.tooltip.computer_id", appender);
        }
    }

    private static <T extends class_9299> void addToTooltip(class_1799 stack, class_9331<T> component, class_1792.class_9635 context, Consumer<class_2561> out, class_1836 flags) {
        class_9299 provider = (class_9299)stack.method_57824(component);
        if (provider != null) {
            provider.method_57409(context, out, flags);
        }
    }

    static {
        TREASURE_DISK_LOOT = class_5321.method_29179((class_5321)class_7924.field_50079, (class_2960)class_2960.method_60655((String)"computercraft", (String)"treasure_disk"));
        TREASURE_DISK_LOOT_TABLES = Set.of(class_39.field_356, class_39.field_472, class_39.field_842, class_39.field_800, class_39.field_683, class_39.field_885, class_39.field_803, class_39.field_662, class_39.field_484, class_39.field_16751);
    }

    private static final class TooltipAppender
    implements Consumer<class_2561> {
        private final List<class_2561> out;
        private int index = 1;

        private TooltipAppender(List<class_2561> out) {
            this.out = out;
        }

        @Override
        public void accept(class_2561 component) {
            this.out.add(this.index++, component);
        }
    }
}

